using System;
using Server;

namespace Server.Items
{
	public class BottledFire : Item
	{	
		[Constructable]
		public BottledFire() : this( 1 )
		{
		}
      
      [Constructable]
		public BottledFire( int amount ) : base( 0x1C18 )
		{
         Name = "bottled fire";
         Weight = 0.1;
			Hue = 2622;
			Stackable = true;
			Amount = amount;
		}

		public BottledFire( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}